import query from '../query/query';
import { database } from '../../config/dbConfig';
import { findCommentDetails } from './FeedsModel';
import { listTreatments } from './ManageTreatmentsModel'
import { listTags } from './ManageTagsModel'
import { getUserFromPostId } from './UserModel';
// Approve/ reject Post
export const change_post_status = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const status = (_body.status == "approved") ? "1" : "0"
                if (status == "0") {
                    var change_post_status = {
                        name: 'change_post_status',
                        text: query.change_post_status,
                        values: [status, _body.feed_id, _body.reason]
                    }
                }
                else {
                    var change_post_status = {
                        name: 'change_post_status',
                        text: query.change_post_status,
                        values: [status, _body.feed_id, ""]
                    }
                }
                const post_details = await client.query(change_post_status);
                if (post_details) {
                    if(status == "0"){
                        const notificationTitle ="Admin removed your post with reason : "+_body.reason;
                        const type = "abusive_content_removed";
                        const data = { post_id: _body.feed_id.toString() }
                        getUserFromPostId(_body.feed_id, notificationTitle, _body.userid, type, data)
                    }
                    resolve({ code: 200, message: "Post status has been successfully changed", data: {} })
                } else {
                    reject({ code: 400, message: "Failed. Please try again.", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// Report Post
export const post_report = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const currentTime = Math.floor(Date.now() / 1000);
                const report_post = {
                    name: 'report_post',
                    text: query.report_post,
                    values: [_body.post_id, true, _body.report_type, _body.report_text, currentTime, _body.userid]
                }
                const post_details = await client.query(report_post);
                if (post_details) {
                    resolve({ code: 200, message: "Post has been successfully reported", data: {} })
                } else {
                    reject({ code: 400, message: "Failed. Please try again.", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// Reply Post
export const post_reply = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const currentTime = Math.floor(Date.now() / 1000);
                const reply_post = {
                    name: 'reply_post',
                    text: query.reply_post,
                    values: [_body.post_id, _body.userid, _body.reply, 1, true, currentTime]
                }
                const post_details = await client.query(reply_post);
                if (post_details) {
                    const notificationTitle = "Admin commented on your post";
                    const type = "comment";
                    const data = { post_id: _body.post_id.toString(),content: _body.reply }
                    getUserFromPostId(_body.post_id, notificationTitle, _body.userid, type, data)
                    resolve({ code: 200, message: "Post has been successfully replied", data: {} })
                } else {
                    reject({ code: 400, message: "Failed. Please try again.", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}


// View all Posts filtered by featured/spam/reported
export const view_all_posts = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            let promise = []
            let finalResult = []
            let totalCount = ''
            const client = await database().connect()
            try {
                var sortStr = ' ' + _body.sort_key + ' ' + _body.order_by;
                if (_body.type == "featured") {
                    var query = `SELECT f.id as feed_id, f.content, f.image,f.created_date, f.type, f.approve_status, u.pseudo_name, u.profile_image,(SELECT COUNT(id) from feeds WHERE feed_status=true AND featured=true) as totalCount FROM feeds f LEFT JOIN users u ON f.user_id = u.id WHERE feed_status=true AND featured=true ORDER BY ${sortStr} LIMIT ${_body.limit} OFFSET ${_body.offset}`
                } else if (_body.type == "reported") {
                    var query = `SELECT f.id as feed_id, f.content, f.image,f.created_date, f.type, f.approve_status, u.pseudo_name, u.profile_image, (SELECT COUNT(id) from feeds WHERE feed_status=true AND reported=true) as totalCount FROM feeds f LEFT JOIN users u ON f.user_id = u.id WHERE feed_status=true AND reported=true ORDER BY ${sortStr} LIMIT ${_body.limit} OFFSET ${_body.offset}`
                } else if (_body.type == "spam") {
                    var query = `SELECT f.id as feed_id, f.content, f.image,f.created_date, f.type, f.approve_status, u.pseudo_name, u.profile_image, (SELECT COUNT(id) from feeds WHERE feed_status=true AND reported=true AND report_type='spam') as totalCount FROM feeds f LEFT JOIN users u ON f.user_id = u.id WHERE feed_status=true AND reported=true AND report_type='spam' ORDER BY ${sortStr} LIMIT ${_body.limit} OFFSET ${_body.offset}`
                } else {
                    var query = `SELECT f.id as feed_id, f.content, f.image,f.created_date, f.type, f.approve_status, u.pseudo_name, u.profile_image, (SELECT COUNT(id) from feeds WHERE feed_status=true) as totalCount FROM feeds f LEFT JOIN users u ON f.user_id = u.id WHERE feed_status=true ORDER BY ${sortStr} LIMIT ${_body.limit} OFFSET ${_body.offset}`
                }

                const post_details = await client.query(query);
                //process result
                post_details.rows.forEach((item, index) => {
                    promise.push(
                        findCommentDetails(item.feed_id, client).then(res => {
                            return res;
                        })
                    )
                    totalCount = item.totalcount
                    finalResult.push(item)
                })
                const result = await Promise.all(promise);
                post_details.rows.forEach((item, index) => {
                    finalResult[index].comments = result[index]
                })
                if (post_details) {
                    resolve({ code: 200, message: "Posts has been successfully fetched", data: finalResult })
                } else {
                    reject({ code: 400, message: "Failed. Please try again.", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// Search Posts
export const post_search = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const sortStr = ' ' + _body.sort_key + ' ' + _body.order_by + ' ';
                const searchKey = _body.search_string ? _body.search_string : "";
                if (_body.type == "featured") {
                    var query = `SELECT f.id as feed_id,(SELECT COUNT(id) from feeds WHERE feed_status=true AND (featured=true AND LOWER(f.content) LIKE LOWER('%${searchKey}%') OR LOWER(u.pseudo_name) LIKE LOWER('%${searchKey}%'))) as totalCount, f.content, f.feeling, f.image, f.type, f.approve_status, f.created_date, 
                    u.id as user_id,u.pseudo_name FROM feeds f 
                    LEFT JOIN users u ON f.user_id = u.id 
                    WHERE feed_status=true AND featured=true AND (LOWER(f.content) LIKE LOWER('%${searchKey}%') OR LOWER(u.pseudo_name) LIKE LOWER('%${searchKey}%')) ORDER BY ${sortStr} LIMIT ${_body.limit} OFFSET ${_body.offset}`
                } else if (_body.type == "reported") {
                    var query = `SELECT f.id as feed_id, (SELECT COUNT(id) from feeds WHERE feed_status=true AND reported=true AND (LOWER(f.content) LIKE LOWER('%${searchKey}%') OR LOWER(u.pseudo_name) LIKE LOWER('%${searchKey}%'))) AS totalCount, f.content, f.feeling, f.image, f.type, f.approve_status, f.created_date, 
                    u.id as user_id,u.pseudo_name FROM feeds f 
                    LEFT JOIN users u ON f.user_id = u.id 
                    WHERE feed_status=true AND reported=true AND (LOWER(f.content) LIKE LOWER('%${searchKey}%') OR LOWER(u.pseudo_name) LIKE LOWER('%${searchKey}%')) ORDER BY ${sortStr} LIMIT ${_body.limit} OFFSET ${_body.offset}`
                } else if (_body.type == "spam") {
                    var query = `SELECT f.id as feed_id, (SELECT COUNT(id) from feeds WHERE feed_status=true AND reported=true AND report_type='spam' AND (LOWER(f.content) LIKE LOWER('%${searchKey}%') OR LOWER(u.pseudo_name) LIKE LOWER('%${searchKey}%'))) AS totalCount, f.content, f.feeling, f.image, f.type, f.approve_status, f.created_date, 
                    u.id as user_id,u.pseudo_name FROM feeds f 
                    LEFT JOIN users u ON f.user_id = u.id 
                    WHERE feed_status=true AND reported=true AND report_type='spam' AND (LOWER(f.content) LIKE LOWER('%${searchKey}%') OR LOWER(u.pseudo_name) LIKE LOWER('%${searchKey}%')) ORDER BY ${sortStr} LIMIT ${_body.limit} OFFSET ${_body.offset}`
                } else {
                    var query = `SELECT f.id as feed_id, (SELECT COUNT(id) from feeds WHERE feed_status=true AND (LOWER(f.content) LIKE LOWER('%${searchKey}%') OR LOWER(u.pseudo_name) LIKE LOWER('%${searchKey}%'))) AS totalCount, f.content, f.feeling, f.image, f.type, f.approve_status, f.created_date, 
                    u.id as user_id,u.pseudo_name FROM feeds f 
                    LEFT JOIN users u ON f.user_id = u.id 
                    WHERE feed_status=true AND (LOWER(f.content) LIKE LOWER('%${searchKey}%') OR LOWER(u.pseudo_name) LIKE LOWER('%${searchKey}%')) ORDER BY ${sortStr} LIMIT ${_body.limit} OFFSET ${_body.offset}`
                }
             
                const post_details = await client.query(query);
                if (post_details) {
                    resolve({ code: 200, message: "Posts has been successfully fetched", data: post_details.rows })
                } else {
                    reject({ code: 400, message: "Failed. Please try again.", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// Admin Global Search
export const global_search_admin = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            let promises = []
            let finalResult = {}
            const client = await database().connect()
            try {
                const searchKey = _body.search_string ? _body.search_string : "";
                //search posts
                const query1 = `SELECT f.id as feed_id, f.content FROM feeds f WHERE LOWER(f.content) LIKE LOWER('%${searchKey}%') LIMIT 5`
                const post_details = await client.query(query1);
                post_details.rowCount > 0 ? finalResult["feeds"] = post_details.rows : ""
                //search users 
                const query2 = `SELECT u.id as user_id, u.first_name, u.last_name from users u WHERE LOWER(u.first_name) LIKE LOWER('%${searchKey}%') OR LOWER(u.last_name) LIKE LOWER('%${searchKey}%') LIMIT 5`
                const user_details = await client.query(query2);
                user_details.rowCount > 0 ? finalResult["users"] = user_details.rows : ""
                //search advertisements
                const query3 = `SELECT ad.id as ad_id, ad.description FROM advertisements ad WHERE (LOWER(ad.description) LIKE LOWER('%${searchKey}%') OR LOWER(ad.company_name) LIKE LOWER('%${searchKey}%')) AND status='1'  LIMIT 5`
                const ad_details = await client.query(query3);
                ad_details.rowCount > 0 ? finalResult["ads"] = ad_details.rows : ""
                //search testimonials
                const query4 = `SELECT t.id as test_id, t.description FROM testimonials t WHERE (LOWER(t.description) LIKE LOWER('%${searchKey}%') OR LOWER(t.author_name) LIKE LOWER('%${searchKey}%')) AND status='1'  LIMIT 5`
                const test_details = await client.query(query4);
                test_details.rowCount > 0 ? finalResult["testimonials"] = test_details.rows : ""

                //search treatments
                promises.push(listTreatments({ search_key: searchKey }))
                //search tags
                promises.push(listTags({ search_key: searchKey }))
                const results = await Promise.all(promises)
                results[0].data.treatments.length > 0 ? finalResult["treatments"] = results[0].data.treatments : ""
                results[1].data.tags.length > 0 ? finalResult["tags"] = results[1].data.tags : ""
                if (post_details || user_details || ad_details || finalResult["treatments"]) {
                    resolve({ code: 200, message: "Search has been successfully completed", data: {results : finalResult, count : Object.keys(finalResult).length}})
                } else {
                    reject({ code: 400, message: "Failed. Please try again.", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}


// get Post details
export const get_post_details = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect();
            try {
                const get_post_details = {
                    name: 'get_post_details',
                    text: query.get_post_details,
                    values: [_body.id]
                }
                var post_details = await client.query(get_post_details);
                resolve({ code: 200, message: "Post details fetched", data: post_details.rows })
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// Dashboard analytics
export const admin_analytics = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const cardDetails = {}
            const chartDetails = {}
            const client = await database().connect()
            try {
                //find new users
                const sevDaysBefore = Math.floor(Math.floor(Date.now() - 7 * 24 * 60 * 60 * 1000) / 1000);
                const query = `SELECT COUNT(id)  as userCount from users where created_date > ${sevDaysBefore}`
                const user_details = await client.query(query);
                user_details.rows[0].usercount ? cardDetails["new_users"] = parseInt(user_details.rows[0].usercount) : ""
                //find new communities
                const query2 = `SELECT COUNT(id)  as comCount from community where created_date > ${sevDaysBefore}`
                const com_details = await client.query(query2);
                com_details.rows[0].comcount ? cardDetails["new_communities"] = parseInt(com_details.rows[0].comcount) : ""
                cardDetails["user_engagment_hours"] = 2.5;
                //get total profile percentage 
                const query3 = `select cast(data2.count2 as float)/ cast(data1.count1 as float) *100 as profile_activity
                from (select count(id) as count1 from users) data1, (select count(id) as count2 from user_details) data2`;
                const profile_details = await client.query(query3);
                profile_details.rows[0].profile_activity ? chartDetails["user_activity_profile"] = Math.round(profile_details.rows[0].profile_activity * 10) / 10 : ""
                //comments
                const query4 = `select cast(data2.count2 as float)/ cast(data1.count1 as float) *100 as comment_activity
                from (select count(id) as count1 from users) data1, (select count(DISTINCT user_id) as count2 from comments) data2`;
                const comment_details = await client.query(query4);
                var other1 = Math.round(comment_details.rows[0].comment_activity)
                //feeds
                const query5 = `select cast(data2.count2 as float)/ cast(data1.count1 as float) *100 as feed_activity
                from (select count(id) as count1 from users) data1, (select count(DISTINCT user_id) as count2 from feeds) data2`;
                const feed_details = await client.query(query5);
                var other2 = Math.round(feed_details.rows[0].feed_activity)
                //like
                const query6 = `select cast(data2.count2 as float)/ cast(data1.count1 as float) *100 as like_activity
                from (select count(id) as count1 from users) data1, (select count(DISTINCT user_id) as count2 from likes) data2`;
                const like_details = await client.query(query6);
                var other3 = Math.round(like_details.rows[0].like_activity)
                //other
                chartDetails["user_activity_other"] = Math.round((other1 + other2 + other3) / 3 * 10) / 10
                //dummy data 
                /* chartDetails["user_activity_journal"] = 0;
                chartDetails["user_activity_community"] = 0;*/
                chartDetails["user_activity_chat"] = 0; 
                let finalData = {
                    cards: cardDetails,
                    chart: chartDetails,
                }
                if (user_details) {
                    resolve({ code: 200, message: "Analytics has been successfully fetched", data: finalData })
                } else {
                    reject({ code: 400, message: "Failed. Please try again.", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}
