
import query from '../query/query';
import { database } from '../../config/dbConfig';
import { blobStorageTempUrl } from '../../services/blobStorage';
import * as dotenv from 'dotenv'
const zipcodes = require('zipcodes');
import { chk_connection_status } from './ConnectionModel';
import { send_invite_sms } from '../../services/smsService';
import { sendGridEmail } from '../../services/sendGridEmail'

// Register User profile
export const register_user_profile = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect()
            try {
                //find location using postal code
                const location = zipcodes.lookup(_body.postal_code);
                const region = location?.region ? location.region : ""
                const lat = location?.latitude ? location.latitude : "0.000"
                const long = location?.longitude ? location.longitude : "0.000"

                if (!_body.pseudo_name) {
                    reject({ code: 400, message: "Failed. Please give a pseudoname.", data: {} });
                }
                const user_register_profile = {
                    name: 'user_register_profile',
                    text: query.register_user_profile,
                    values: [_body.first_name, _body.last_name, _body.address, _body.gender, _body.dob, _body.pseudo_name, currentTime, _body.postal_code, _body.profile_image, _body.user_type, _body.userid, _body.nationality, location, lat, long]
                }
                await client.query(user_register_profile);
                const user_details_register = {
                    name: 'user_details_register',
                    text: query.user_details_register,
                    values: [_body.userid, _body.banner_image, _body.occupation, _body.education, _body.marital_status, _body.nationality, _body.living_status, _body.interest_areas, _body.hobbies, _body.your_expectation]
                }
                await client.query(user_details_register);
                const names = ['address', 'gender', 'dob', 'postal_code', 'pseudo_name', 'phone', 'email', 'profile_image', 'banner_image', 'occupation', 'education', 'marital_status', 'nationality', 'living_status', 'interest_areas', 'hobbies', 'your_expectation', 'treatments', 'primary_condition', 'other_conditions', 'connection_count']
                names.forEach(async function (names) {
                    const add_privacy = {
                        name: 'add_privacy',
                        text: query.user_privacy,
                        values: [names, _body.id]
                    }
                    await client.query(add_privacy);
                })
                resolve({ code: 200, message: "User profile has been successfully registered", data: {} });
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// List User profile
export const list_user_profile = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const user_list_profile = {
                    name: 'user_list_profile',
                    text: query.user_list_profile,
                    values: [_body.user_id, _body.userid]
                }
                const user_details = await client.query(user_list_profile);
                if (user_details.rows[0]?.location == "" || user_details.rows[0]?.location == null || user_details.rows[0]?.location == "{}") {
                }
                else {
                    user_details.rows[0].location = JSON.parse(user_details.rows[0].location).city;
                }
                user_details.rows[0].connection_status = user_details.rows[0].connected && user_details.rows[0].connected != null ? parseInt(user_details.rows[0].connected) : 0
                delete (user_details.rows[0].connected)
                resolve({ code: 200, message: "User profile has been successfully fetched", data: user_details.rows[0] });
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })

}


// List User privacy
export const list_user_privacy = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const list_user_privacy = {
                    name: 'list_user_privacy',
                    text: query.list_user_privacy,
                    values: [_body.user_id]
                }
                const user_details = await client.query(list_user_privacy);

                resolve({ code: 200, message: "User privacy details has been successfully fetched", data: user_details.rows });
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })

}


// List User privacy
export const edit_user_privacy = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const edit_user_privacy = {
                    name: 'edit_user_privacy',
                    text: query.edit_user_privacy,
                    values: [_body.privacy_status, _body.id]
                }
                const user_details = await client.query(edit_user_privacy);

                resolve({ code: 200, message: "User privacy details has been successfully updated", data: {} });
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })

}


// Edit User profile
export const edit_user_profile = (body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect()
            try {
                const check_email = {
                    name: 'check_email',
                    text: query.user_email_ckeck,
                    values: [body.email, 1, body.userid, '']
                }
                const check_phone = {
                    name: 'check_phone',
                    text: query.user_phone_ckeck,
                    values: [body.phone, 1, body.userid, '']
                }
                // // Check email duplicate
                const user_email = await client.query(check_email);
                // // Check phone duplicate
                const user_phone = await client.query(check_phone);
                if (user_email.rows.length > 0) {
                    reject({ code: 400, message: "Failed. Email Address already exist.", data: {} });
                } else if (user_phone.rows.length > 0) {
                    reject({ code: 400, message: "Failed. Phone Number already exist.", data: {} });
                } else {
                    //find location using postal code
                    const location = zipcodes.lookup(body.postal_code);
                    const region = location?.region ? location.region : ""
                    const lat = location?.latitude ? location.latitude : "0.000"
                    const long = location?.longitude ? location.longitude : "0.000"
                    const edit_user_profile = {
                        name: 'edit_user_profile',
                        text: query.edit_user_profile,
                        values: [body.gender, body.dob, body.postal_code, body.first_name, body.last_name, body.phone, body.profile_image, body.address, body.user_type, body.pseudo_name, body.userid, body.nationality, 1, location, body.email]
                    }
                    const user_details = await client.query(edit_user_profile);
                    const edit_user_details = {
                        name: 'edit_user_details',
                        text: query.edit_user_details,
                        values: [body.banner_image, body.occupation, body.education, body.marital_status, body.nationality, body.living_status, body.interest_areas, body.hobbies, body.your_expectation, body.userid]
                    }
                    const user_more_details = await client.query(edit_user_details);

                    resolve({ code: 200, message: "User profile has been successfully updated", data: user_details.rows[0] });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// Edit User profile
export const edit_user_profile_mw = (body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect()
            try {
                const check_email = {
                    name: 'check_email',
                    text: query.user_email_ckeck,
                    values: [body.email, 1, body.userid, '']
                }
                const check_phone = {
                    name: 'check_phone',
                    text: query.user_phone_ckeck,
                    values: [body.phone, 1, body.userid, '']
                }
                // // Check email duplicate
                const user_email = await client.query(check_email);
                // Check phone duplicate
                const user_phone = await client.query(check_phone);
                if (user_email.rows.length > 0) {
                    reject({ code: 400, message: "Failed. Email Address already exist.", data: {} });
                } else if (user_phone.rows.length > 0) {
                    reject({ code: 400, message: "Failed. Phone Number already exist.", data: {} });
                } else {
                    //find location using postal code
                    const location = zipcodes.lookup(body.postal_code);
                    const region = location?.region ? location.region : ""
                    const lat = location?.latitude ? location.latitude : "0.000"
                    const long = location?.longitude ? location.longitude : "0.000"
                    const edit_user_profile = {
                        name: 'edit_user_profile',
                        text: query.edit_user_profile_mw,
                        values: [body.gender, body.dob, body.postal_code, body.first_name, body.last_name, body.phone, body.profile_image, body.address, body.user_type, body.pseudo_name, body.userid, body.nationality, 1, location, body.email]
                    }
                    const user_details = await client.query(edit_user_profile);
                    const edit_user_details = {
                        name: 'edit_user_details',
                        text: query.edit_user_details,
                        values: [body.banner_image, body.occupation, body.education, body.marital_status, body.nationality, body.living_status, body.interest_areas, body.hobbies, body.your_expectation, body.userid]
                    }
                    const user_more_details = await client.query(edit_user_details);

                    resolve({ code: 200, message: "User profile has been successfully updated", data: user_details.rows[0] });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// Check profile percentage
export const check_profile_percentage = (body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const profilePercentageQuery = {
                    name: 'get-profile-percentage',
                    text: query.get_profile_percentage,
                    values: [body.userid],
                }
                const profilePercentageData = await client.query(profilePercentageQuery);
                const data = profilePercentageData.rows[0];
                const dataKeys = Object.keys(data);
                var nullLength = dataKeys.filter(item => data[item] == null || data[item] == '' || data[item] == 'null').length
                if (data.email || data.phone) {
                    var dataKeyLength = dataKeys.length - 1;
                } else dataKeyLength = dataKeys.length
                if (data.email && data.phone) {
                    //do nothing
                } else nullLength = nullLength - 1
                resolve({ code: 200, message: "Success", data: { nullLength, totalLength: dataKeyLength } }); //dataKeys.length
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}


// Register User profile
export const register_helingmate_profile = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect()
            try {
                //find location using postal code
                const location = zipcodes.lookup(_body.postal_code);
                const region = location?.region ? location.region : ""
                const lat = location?.latitude ? location.latitude : "0.000"
                const long = location?.longitude ? location.longitude : "0.000"
                const helingmate_chk_email_phone = {
                    name: 'helingmate_chk_email_phone',
                    text: query.helingmate_chk_email_phone,
                    values: [_body.phone, _body.email]
                }
                let user_status = await client.query(helingmate_chk_email_phone);
                if (user_status.rows.length == 0) {
                    let userType = "helingmate";
                    const register_helingmate_profile = {
                        name: 'register_helingmate_profile',
                        text: query.register_helingmate_profile,
                        values: [_body.email, _body.phone, _body.first_name, _body.last_name, _body.address, _body.gender,
                        _body.dob, _body.pseudo_name, currentTime, _body.postal_code, _body.profile_image, userType,
                        _body.nationality, location, lat, long, 1]
                    }
                    let user_data = await client.query(register_helingmate_profile);
                                    
                    const user_details_register = {
                        name: 'user_details_register',
                        text: query.user_details_register,
                        values: [user_data.rows[0].id, _body.banner_image, _body.occupation, _body.education, _body.marital_status, _body.nationality, _body.living_status, _body.interest_areas, _body.hobbies, _body.your_expectation]
                    }
                    await client.query(user_details_register);
                  
                    const names = ['address', 'gender', 'dob', 'postal_code', 'pseudo_name', 'phone', 'email', 'profile_image', 'banner_image', 'occupation', 'education', 'marital_status', 'nationality', 'living_status', 'interest_areas', 'hobbies', 'your_expectation', 'treatments', 'primary_condition', 'other_conditions', 'connection_count']
                    names.forEach(async function (names) {
                        const add_privacy = {
                            name: 'add_privacy',
                            text: query.user_privacy,
                            values: [names, _body.id]
                        }
                        await client.query(add_privacy);
                    })
                    if (_body.phone) {
                        var title = 'Dear Helingmate, You have been successfully onboarded at MHM. Please login using the MHM mobile app or website. Thank you!'
                        send_invite_sms(title, _body.phone)
                    }
                    if (_body.email) {
                        const mailData = { to: _body.email, templateName: "otp_mail", title: "Helingmate - Successfully onboarded", description: "Dear Helingmate, You have been successfully onboarded at MHM. Please login using the MHM mobile app or website. Thank you!" }
                        sendGridEmail(mailData)
                    }

                    resolve({ code: 200, message: "Helingmate user profile has been successfully registered", data: {user_id:user_data.rows[0].id} });
                } else {
                    reject({ code: 400, message: "Failed. User already registered.", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}