import { v4 as uuidv4 } from 'uuid';

const fs = require('fs')
const path = require('path')
const utils = require('util')
const hb = require('handlebars')
const readFile = utils.promisify(fs.readFile)
var pdf = require('html-pdf');
var phantomjs = require('phantomjs-prebuilt')

var options = {
    format: 'A4',
    "phantomPath": phantomjs.path, // PhantomJS binary which should get downloaded automatically
    "phantomArgs": [], // array of strings used as phantomjs args e.g. ["--ignore-ssl-errors=yes"]
    "timeout": 100000,
    "border": "15px" ,          // Timeout that will cancel phantomjs, in milliseconds
    "header": {
        "height": "93px",

      },
      "footer": {
        "height": "220px",
      }
    
      
};

export async function generatePdf(_body) {
    return new Promise((resolve, reject) => {
        (async () => {
        let data = {
            "consultationId": _body.consultationId,
            "physicianID": _body.physicianID,
            "patientID": _body.patientID,
            "patient_first_name": _body.patient_first_name,
            "patient_last_name": _body.patient_last_name,
            "patient_dob": _body.patient_dob,
            "gender": _body.gender,
            "expert_first_name": _body.expert_first_name,
            "expert_last_name": _body.expert_last_name,
            "qualification": _body.qualification,
            "address_line1": _body.address_line1,
            "address_line2": _body.address_line2,
            "state_name": _body.state_name,
            "registraion_number": _body.registraion_number,
            "sign": _body.sign,
            "clinicName": _body.clinicName,
            "clinicAddress": _body.clinicAddress,
            "clinicLogo": _body.clinicLogo,
            "clinicPhone": _body.clinicPhone,
            "consultationStartTimestamp": _body.consultationStartTimestamp,
            "consultationEndTimestamp": _body.consultationEndTimestamp,
            "case_history": _body.case_history,
            "presenting_complaint": _body.presenting_complaint,
            "treatment_advice": _body.treatment_advice
        };
        // getTemplateHtml().then
        // (async () => {
            var res = `
    <html>
    
    <head>
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Poppins&display=swap" rel="stylesheet">
    </head>
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            height:100%;
            margin: 0 !important;
        }
    
        hr {
            opacity: .1;
        }
    
        .header-div {
            padding: 5px 10px 5px 10px;
           
        }
    
        .logo {
            width: 150px;
        }
    
        .physician-details-div {
          
        }
    
        .logo-div {
            align-self: center;
        }
        
    
        .pdf-main-div {
            height: max-content;
           border-right: solid 1px rgba(128, 128, 128, 0.1);
            border-left: solid 1px rgba(128, 128, 128, 0.1);
        }
        .header-section{
            border: solid 1px rgba(128, 128, 128, 0.1);
        }
    
        .medical-record-main-div {
            padding: 10px;
        }
    
        .label-p {
            font-size: 7px;
            margin-bottom: 0px;
        }
    
        .label-value-p {
            margin-top: 0px;
            font-size: 9px;
            margin-bottom: 0px;
        }
    
        .medical-recods-row-div {
    
            /* display: flex; */
            /* gap: 20px; */
        }
    
        .medical-recods-row-div>table>tbody>tr>td>div {
            margin-right: 10px;
        }
    
        .medical-records-h3 {
            margin: 0px;
        }
    
        .case-history-main-div,
        .physician-name-sig-main-div {
            padding: 5px 10px;
        }
    
        .physician-name-1 {
            text-align: end;
        }
    
        .footer-details-main-div {
            /* display: flex; */
            align-items: center;
            padding: 5px 10px;
        }
    
        .footer-immage-div {
            width: -webkit-fill-available;
            text-align: end;
        }
    
        .column1-phy-details-main-div {
            width: -webkit-fill-available;
    
        }
    
        p {
            font-size: 8px;
        }
        h4 {
            margin: 0px 0px;
            font-size: 9px;
        }
    
        h3 {
            font-size: 11px;
        }
       .footer-section{
        border-top:none;
        border: solid 1px rgba(128, 128, 128, 0.1);
       }
       .horizontal-line{
           width:100%;
           height:1px;
           border-bottom:solid 1px rgba(128, 128, 128, 0.1);
       }
       
        
    </style>
    
    <body>
    <div class="overflow-div">
    
   
        <div class="pdf-main-div">

        <div id="pageHeader" class="header-section" style="height:90px;">
            <div class="header-div" style="position:relative;">
                <table style="width: 100%;left:0">
                    <tbody>
                        <tr>
                            <td style="width: 75%;height:90px;position:absolute">
                                <div class="logo-div">
                                    <img class="logo"  src="{{clinicLogo}}" alt="">
                                </div>
                            </td>
                            <td style="width: 75%;height:90px;position:absolute">
                                <div class="logo-div">
                                    <img class="logo" src="{{clinicLogo}}" alt="">
                                </div>
                            </td>
                            <td style="width: 25%;height:90px;position:absolute;right:0">
                                <div class="physician-details-div">
                                <div>
                                    <h4>Dr {{expert_first_name}} {{expert_last_name}}</h4>
                                    <p>{{qualification}}<br>
                                        {{address_line1}}<br>
                                        {{address_line2}}<br>
                                        Medical Registration : {{registraion_number}}
                                    </p>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            </div>
            
            
            <div class="medical-record-main-div">
                <h4 class="medical-records-h3" style="margin-bottom: 5px;">Medical Records</h4>
                <div class="medical-recods-row-div">
                    <table>
                        <tr>
                            <td style="padding-right: 25px;">
                                <div class="pateint-name-div">
                                    <p class="label-p">
                                        Patient Name
                                    </p>
                                    <p class="label-value-p">{{patient_first_name}} {{patient_last_name}}
                                    </p>
                                </div>
                            </td>
                            <td style="padding-right: 25px;">
                                <div class="pateint-name-div">
                                    <p class="label-p">
                                        Gender
                                    </p>
                                    <p class="label-value-p">
                                        {{gender}}
                                    </p>
                                </div>
                            </td>
                            <td style="padding-right: 25px;">
                                <div class="pateint-name-div">
                                    <p class="label-p">
                                        Date of Birth
                                    </p>
                                    <p class="label-value-p">
                                        {{patient_dob}}
                                    </p>
                                </div>
                            </td>
                            <td style="padding-right: 25px;">
                                <div class="pateint-name-div">
                                    <p class="label-p">
                                        Start Date
                                    </p>
                                    <p class="label-value-p">
                                        {{consultationStartTimestamp}}
                                    </p>
                                </div>
                            </td>
                            <td style="padding-right: 25px;">
                                <div class="pateint-name-div">
                                    <p class="label-p">
                                        End Date
                                    </p>
                                    <p class="label-value-p">
                                        {{consultationEndTimestamp}}
                                    </p>
                                </div>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>

            <hr>

            <div class="case-history-main-div">
                <h4 class="medical-records-h3">Case History</h4>
                <p>{{case_history}}</p>
            </div>

            <hr>

            <div class="case-history-main-div">
                <h4 class="medical-records-h3">Presenting Complaint</h4>
                <p>{{presenting_complaint}}</p>
            </div>

            <hr>
    
            <div class="case-history-main-div">
                <h4 class="medical-records-h3">Treatment Advice</h4>
                <p>{{treatment_advice}}</p>
            </div>
    
            <hr>
            <div class="physician-name-sig-main-div">
                <div class="physician-name-1">
                    <img class="logo" src="{{sign}}" alt="">
                </div>
                <div class="physician-name-1">
                    <h4 style="margin-bottom:0px">Dr {{expert_first_name}} {{expert_last_name}}</h4>
                    <p style="margin: 0px;">{{qualification}}</p>
                </div>
            </div>
        
            
            <div id="pageFooter" class="footer-section">

            <div class="footer-details-main-div">
                <table style="width: 100%;">
                    <tbody>
                        <tr>
                            <td>
                                <div class="column1-phy-details-main-div">
                                <h4>MYHEALINGMATE HEALTH SOLUTIONS PVT. LTD.</h4>
                                <p>
                                C-177, B-Suite 004, Defence Colony, Delhi<br>
                                India, 110024<br>
                                Phone : +91-011-4222-4002<br>
                                Email : help@myhealingmate.com<br>
                                Website : www.myhealingmate.com<br>
                                </p>
                                </div>
                            </td>
                            <td>
                                <div class="footer-immage-div">
                                    <img class="logo" src="{{clinicLogo}}" alt="">
    
                                </div>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <div class="horizontal-line"></div>

            <div class="disclaimer-main-div" style="padding: 5px;">
                <p style="text-align: center;font-size: 7px;">
                    Disclaimer : This prescription is based on the information provided by you in an online consultation and
                    not on any physical verification. Visit a doctor incase of emergency. This prescription is valid in
                    India only
                </p>
            </div>
    
            <div class="disclaimer-main-div" style="padding: 0px 10px 10px 10px;text-align: center;">
                <p style="font-size: 7px;">
                    This consultation is offered on the tech platform operated by<b> My Healing Mate</b>. If you need any further clarification, kindly write to <b>help@myhealingmate.com<b>
                </p>
            </div>
            </div>
            

        </div>
        </div>
    </body>
    
    </html>`
            console.log("Compiling the template with handlebars")
            const template = hb.compile(res, { strict: true });
            const result = template(data);
            const html = result;
            pdf.create(html, options).toBuffer(function (err, buffer) {
                if (err) {
                    console.log("error", err)
                    reject({ status: "Failed", data: "" })
                }
                else {
                    var base_pdf = buffer.toString('base64')
                    var filename = uuidv4();
                    var blobName = "prescription/" + filename + ".pdf"
                    var body = {
                        "uploadData": [
                            {
                                "blobName": blobName,
                                "data": base_pdf
                            }
                        ],
                        "containerName": "private"
                    }
                    resolve({ status: "success", data: body })
                }

            });
        })().catch(err => {
            console.error(err)
        });
    });
}






