export default {
    register_user: `INSERT INTO users(email,phone,auth_otp,auth_otp_exp,created_date,profile_registration_status,user_type)VALUES ($1,$2,$3,$4,$5,0,$6) RETURNING id,email,phone`,
    check_otp: `SELECT id,email,phone FROM users WHERE auth_otp=$1`,
    register_user_profile: `UPDATE users SET first_name = $1,last_name = $2,address = $3,gender = $4,dob = $5,pseudo_name = $6,updated_date = $7, postal_code = $8,profile_image = $9,user_type = $10, nationality = $12, location=$13, latitude=$14, longitude=$15, profile_registration_status=1 WHERE id=$11;`,
    register_helingmate_profile: `INSERT INTO users(email,phone,first_name,last_name,address,gender,dob,pseudo_name,created_date,postal_code,profile_image,user_type,nationality,location,latitude,longitude,profile_registration_status,status) VALUES ($1,$2,$3,$4,$5,$6,$7,$8,$9,$10,$11,$12,$13,$14,$15,$16,$17,$17) RETURNING id,email,phone`,
    user_status_update: `UPDATE users SET status = $1 WHERE id=$2;`,
    login_user_email : ` SELECT u.id,u.email,u.pseudo_name,u.phone,u.user_type,u.profile_image,ud.banner_image,u.profile_registration_status FROM users u LEFT JOIN user_details as ud ON ud.user_id=u.id WHERE email=$1 AND status=$2 AND user_type NOT IN('manager','physician')`,
    login_user_phone : ` SELECT u.id,u.email,u.pseudo_name,u.phone,u.user_type,u.profile_image,ud.banner_image,u.profile_registration_status FROM users u LEFT JOIN user_details as ud ON ud.user_id=u.id WHERE phone=$1 AND status=$2 AND user_type NOT IN('manager','physician')`,
    login_super_admin: ` SELECT id,email,phone,first_name,last_name FROM users WHERE email=$1 AND password=$2 AND status=$3`,
    user_email_ckeck: ` SELECT id FROM users WHERE email=$1 AND status=$2 AND id !=$3 AND email !=$4 `,
    user_phone_ckeck: ` SELECT id FROM users WHERE phone=$1 AND status=$2 AND id !=$3 AND phone !=$4 `,
    user_auth_otp_update: `UPDATE users SET auth_otp = $1 WHERE id=$2;`,
    add_comment: `INSERT INTO comments(parent_id,type,comment,status,created_date,user_id,publish_status)VALUES ($1,$2,$3,$4,$5,$6,$7) RETURNING id`,
    list_comment_login: ` SELECT c.id as comment_id,c.parent_id,c.comment,c.type,c.created_date,u.id as user_id,u.first_name,u.last_name,u.profile_image, count(*) OVER() AS totalCount FROM comments as c JOIN users as u on c.user_id=u.id WHERE c.status=$1 AND parent_id=$2 AND type=$3`,
    // list_comment_logout: ` SELECT *,count(*) OVER() AS totalCount FROM comments WHERE status=$1 AND parent_id=$2 AND type=$3`,
    list_comment_login_admin: ` SELECT c.id as comment_id, c.parent_id, c.comment,c.type,c.created_date,c.publish_status, u.id as user_id,u.pseudo_name, u.profile_image,
    (SELECT COUNT(id) from reactions WHERE comment_id=c.id AND content_type='comment') as reactionCount, 
    (SELECT reaction_type from reactions r WHERE r.comment_id=c.id AND r.user_id=$1),count(*) OVER() AS totalCount FROM comments as c 
    LEFT JOIN users as u on c.user_id=u.id 
    WHERE c.status='1' AND parent_id=$2 AND type='feeds'`,
    // list_comment_logout_admin: ` SELECT *,count(*) OVER() AS totalCount FROM comments WHERE status=$1 AND parent_id=$2 AND type=$3 `,
    list_comment_login_admin_without_parent: ` SELECT c.id as comment_id, c.parent_id, c.comment,c.type,c.created_date,c.publish_status, u.id as user_id, 
    u.pseudo_name, u.profile_image,
    (SELECT COUNT(id) from reactions WHERE comment_id=c.id AND content_type='comment') as reactionCount, 
    (SELECT reaction_type from reactions r WHERE r.comment_id=c.id AND r.user_id=$1),count(*) OVER() AS totalCount FROM comments as c 
    LEFT JOIN users as u on c.user_id=u.id 
    WHERE c.status='1' AND type='feeds'`,
    // list_comment_logout_admin_without_parent: ` SELECT *,count(*) OVER() AS totalCount FROM comments WHERE status=$1 AND type=$3`,
    user_save_social: `INSERT INTO social_media(user_id,auth_token,login_type,created_on)VALUES ($1,$2,$3,$4) RETURNING id`,
    user_update_social: `UPDATE social_media SET auth_token = $2,updated_on = $4 WHERE user_id = $1 AND login_type = $3 RETURNING id`,
    register_social_user: `INSERT INTO users(email,phone,status,created_date,profile_registration_status,user_type)VALUES ($1,$2,$3,$4,$5,$6) RETURNING id,profile_registration_status`,
    // check_user_loggedin: `SELECT user_id FROM social_media WHERE auth_token=$1 AND login_type=$2`,
    // check_user_loggedin: `SELECT * FROM social_media WHERE user_id=$1 AND login_type=$2`,
    check_userid_auth: `SELECT id FROM social_media WHERE auth_token=$1 AND user_id = $2 AND login_type= $3`,
    check_userid_auth1: `SELECT id FROM social_media WHERE user_id = $1 AND login_type= $2`,
    update_comment: `UPDATE comments SET comment = $1,updated_date = $2 WHERE id=$3`,
    delete_comment: `UPDATE comments SET updated_date = $1, status=$2 WHERE id=$3`,
    update_otp_email: `UPDATE users SET auth_otp = $1, updated_date=$2 WHERE email=$3 RETURNING id`,
    update_otp_phone: `UPDATE users SET auth_otp = $1, updated_date=$2 WHERE phone=$3 RETURNING id`,
    //user_list_profile : `SELECT * FROM users WHERE id=$1`,
    user_list_profile: `SELECT u.id as userid,*, (SELECT COUNT(id) FROM connections where (user_id1=$1 AND status=1) OR (user_id2=$1 AND status=1)) as connection_count,
    (SELECT user_id1 as sender_id from connections where (user_id1=$1 AND user_id2=$2) OR (user_id1=$2 AND user_id2=$1) AND (status=2 OR status=1)),
    (SELECT SUM(status) as connected from(SELECT status FROM connections WHERE user_id1=$1 AND user_id2=$2 UNION ALL SELECT status FROM connections WHERE user_id1=$2 AND user_id2=$1) as connected)
    FROM users as u 
    LEFT JOIN user_details as ud on u.id=ud.user_id 
    WHERE u.id=$1`,
    edit_user_profile: `UPDATE users SET gender = $1,dob = $2,postal_code = $3,first_name = $4,last_name = $5,phone = $6,profile_image = $7,address = $8,user_type=$9,pseudo_name=$10, nationality=$12, profile_status=$13,location=$14,email=$15 WHERE id=$11 RETURNING id,email,phone`,
    edit_user_profile_mw: `UPDATE users SET gender = $1,dob = $2,postal_code = $3,first_name = $4,last_name = $5,phone = $6,profile_image = $7,address = $8,user_type=$9,pseudo_name=$10, nationality=$12, profile_status=$13,location=$14,email=$15 WHERE id=$11 RETURNING id,email,phone`,
    edit_user_details: `UPDATE user_details SET banner_image = $1,occupation = $2,education = $3,marital_status = $4,nationality = $5, living_status = $6,interest_areas = $7,hobbies = $8,your_expectation = $9 WHERE user_id=$10 RETURNING id`,
    add_condition: `INSERT INTO conditions(condition_id,condition,user_id,status,is_primary,treatment_id,created_date,treatment)VALUES($1,$2,$3,$4,$5,$6,$7,$8) RETURNING id`,
    condition_delete: `UPDATE conditions SET status = $1 WHERE condition_id=$2 AND user_id=$3`,
    list_condition: `SELECT "id","condition_id","condition", "user_id", "status","is_primary","treatment","treatment_id","created_date" FROM conditions WHERE user_id=$1 AND status=$2`,
    user_chk_email: `SELECT id,email,phone FROM users WHERE email=$1 AND status::integer = 1 AND user_type NOT IN('manager','physician') `,
    user_chk_phone: `SELECT id,email,phone FROM users WHERE phone=$1 AND status::integer = 1 AND user_type NOT IN('manager','physician') `,
    helingmate_chk_email_phone: `SELECT id,email,phone FROM users WHERE (email=$2 OR phone=$1) AND status::integer = 1 AND user_type NOT IN('manager','physician') `,
    add_like: `INSERT INTO likes(user_id,like_count,type_id,type_name,created_date)VALUES($1,$2,$3,$4,$5) RETURNING id`,
    update_like: `UPDATE likes SET like_count = $1,updated_date=$5 WHERE user_id=$2 AND type_id=$3 AND type_name=$4 `,
    add_subscription: `INSERT INTO subscription(email,phone,expert,community,app,subs_on,type,created_date)VALUES($1,$2,$3,$4,$5,$6,$7,$8) RETURNING id`,
    chk_subscription_email: `SELECT id FROM subscription WHERE email=$1 AND status=$2 AND type=$3`,
    chk_subscription_phone: `SELECT id FROM subscription WHERE phone=$1 AND status=$2 AND type=$3`,
    chk_like: `SELECT id,like_count FROM likes WHERE user_id=$1 AND type_id=$2 AND type_name=$3`,
    add_mhm_logs: `INSERT INTO logs(log_name,details,user_id,module,created_date)VALUES($1,$2,$3,$4,$5)`,
    user_details_register: `INSERT INTO user_details(user_id,banner_image,occupation,education,marital_status,nationality,living_status,interest_areas,hobbies,your_expectation)VALUES ($1,$2,$3,$4,$5,$6,$7,$8,$9,$10) RETURNING id`,
    user_privacy: `INSERT INTO user_privacy(column_name,user_id)VALUES ($1,$2) RETURNING id`,
    list_user_privacy: `SELECT "id","column_name","privacy_status","user_id" FROM user_privacy WHERE user_id=$1`,
    edit_user_privacy: `UPDATE user_privacy SET privacy_status = $1 WHERE id=$2 `,
    get_profile_percentage: `SELECT u.first_name,u.last_name,u.email,u.address,u.dob,u.phone,u.gender,u.postal_code,u.profile_image,ud.occupation,ud.education,ud.marital_status,ud.living_status,ud.nationality,ud.interest_areas,ud.hobbies,ud.your_expectation from users u left join user_details ud on ud.user_id = u.id where u.id = $1 and u.status::integer = 1`,
    //testimonials
    add_testimonial: 'INSERT INTO testimonials(author_name,created_on,publish_status,description,media,thumbnail,media_type,status,created_by_user_id)VALUES ($1,$2,$3,$4,$5,$6,$7,$8,$9) RETURNING id,author_name,created_on,publish_status,description,media,thumbnail,media_type',
    update_testimonial: 'UPDATE testimonials SET description = $1,media = $2,thumbnail = $3,media_type = $4,created_on = $5,author_name=$7,publish_status=$8,updated_by_user_id=$9 WHERE id=$6 RETURNING id, author_name,created_on,publish_status,description,media,thumbnail,media_type',
    delete_testimonial: 'UPDATE testimonials SET status = $2,deleted_by_user_id=$3 WHERE id=$1 RETURNING id',
    search_testimonial: 'SELECT id, author_name,created_on,publish_status,description,media,thumbnail,media_type FROM testimonials WHERE (LOWER(author_name) LIKE LOWER($1) OR LOWER(description) LIKE LOWER($1)) AND status::integer = 1',
    publish_testimonial: 'UPDATE testimonials SET publish_status = 1,published_by_user_id=$2 WHERE id = $1 RETURNING id, author_name,created_on,publish_status,description,media,thumbnail,media_type',
    list_testimonials: 'SELECT id, author_name,created_on,publish_status,description,media,thumbnail,media_type FROM testimonials WHERE status::integer = 1',
    count_testimonials: 'SELECT count(*) FROM testimonials WHERE status::integer = 1',
    //advertisements
    add_advertisement: 'INSERT INTO advertisements(company_name,created_on,publish_status,description,media,thumbnail,media_type,status,created_by_user_id)VALUES ($1,$2,$3,$4,$5,$6,$7,$8,$9) RETURNING id, company_name,created_on,publish_status,description,media,thumbnail,media_type',
    update_advertisement: 'UPDATE advertisements SET description = $1,media = $2,thumbnail = $3,media_type = $4,created_on = $5,company_name=$7,publish_status=$8,updated_by_user_id=$9 WHERE id=$6 RETURNING id,company_name,created_on,publish_status,description,media,thumbnail,media_type',
    list_advertisements: 'SELECT id, company_name,created_on,publish_status,description,media,thumbnail,media_type FROM advertisements WHERE status::integer = 1',
    search_advertisements: 'SELECT id, company_name,created_on,publish_status,description,media,thumbnail,media_type FROM advertisements WHERE (LOWER(company_name) LIKE LOWER($1) OR LOWER(description) LIKE LOWER($1)) AND status::integer = 1 ',
    delete_advertisement: 'UPDATE advertisements SET status = $2,deleted_by_user_id=$3 WHERE id=$1 RETURNING id',
    publish_advertisement: 'UPDATE advertisements SET publish_status = 1,published_by_user_id=$2 WHERE id = $1 RETURNING id, company_name,created_on,publish_status,description,media,thumbnail,media_type',
    count_advertisements: 'SELECT count(*) FROM advertisements WHERE status::integer = 1',
    //feeds
    add_post: `INSERT INTO feeds(user_id,community_id,content,feeling,image,featured,type,created_date,updated_date,feed_status,content_privacy)VALUES ($1,$2,$3,$4,$5,$6,$7,$8,$8,$9,$10) RETURNING id`,
    delete_post: `UPDATE feeds SET feed_status=$1 WHERE id=$2`,
    feed_list: `SELECT id FROM feeds f WHERE feed_status=$3 AND approve_status=true ORDER BY id DESC LIMIT $1 OFFSET $2`,
    feed_list_user:`SELECT id FROM feeds f WHERE f.user_id=$4 AND feed_status=$3 AND approve_status=true ORDER BY id DESC LIMIT $1 OFFSET $2`,
    feed_list2: `SELECT f.id as feed_id,f.share_count, f.content, f.feeling, f.image as media,f.created_date, u.id as user_id, u.pseudo_name, u.profile_image FROM feeds f LEFT JOIN users u ON f.user_id = u.id WHERE f.id=$1`,
    comment_list: `SELECT c.comment, c.created_date, c.updated_date,u.pseudo_name, u.profile_image,count(*) OVER() AS totalCount FROM comments c LEFT JOIN users u ON c.user_id = u.id WHERE c.parent_id=$1 AND c.status='1' LIMIT 5`,
    update_post: `UPDATE feeds SET user_id=$2,community_id=$3, content= $4,feeling =$5, image=$6, featured=$7, type=$8, updated_date=$9,content_privacy=$10  WHERE id=$1 RETURNING id`,
    react_list: `SELECT r.user_id, r.reaction_type, (SELECT COUNT(*) FROM reactions r WHERE r.feed_id=$1 AND r.reaction_status=$2) AS react_count FROM reactions r WHERE r.feed_id=$1 AND r.reaction_status=$2`,
    post_share: `UPDATE feeds SET share_count = share_count + 1 WHERE id =$1`,
    //reactions
    chk_reaction: `SELECT COUNT(*) FROM reactions WHERE feed_id=$1 AND user_id=$2 AND reaction_status=true UNION ALL SELECT COUNT(*) FROM reactions WHERE feed_id=$1 AND reaction_status=true`,
    chk_reaction_nologin: `SELECT COUNT(*) FROM reactions WHERE feed_id=$1 AND reaction_status=true`,
    add_reaction: `INSERT INTO reactions(reaction_type, reaction_status, content_id, content_type, feed_id, user_id, created_date, updated_date) VALUES ($1,$2,$3,$4,$5,$6,$7,$7) RETURNING id`,
    update_reaction: `UPDATE reactions SET reaction_type=$1,reaction_status=$2,updated_date=$5 WHERE feed_id=$3 AND user_id=$4  RETURNING id`,
    get_reactions: `SELECT r.id ,r.reaction_type,u.first_name,u.last_name, u.pseudo_name, u.profile_image, (SELECT count(id) FROM reactions WHERE reaction_type='support' AND reaction_status=true AND content_type='article' AND feed_id=$1) AS support_count, (SELECT count(id) FROM reactions WHERE reaction_type='help' AND reaction_status=true AND content_type='article' AND feed_id=$1) AS help_count, (SELECT count(id) FROM reactions WHERE reaction_type='applause' AND reaction_status=true AND content_type='article' AND feed_id=$1) AS applause_count FROM reactions r LEFT JOIN users u ON r.user_id = u.id WHERE r.reaction_status=true AND content_type='article' AND r.feed_id=$1`,
    global_search: `SELECT f.id as feed_id, f.content, f.type, f.community_id, f.feeling, f.image, f.share_count,f.created_date, 
    u.id as user_id, u.first_name, u.last_name,u.pseudo_name, u.profile_image, u.nationality, u.location, c.id as community_id, c.name as communityName, (SELECT count(*) FROM comments c WHERE c.parent_id=f.id) AS comment_count, (SELECT count(*) FROM reactions r WHERE r.feed_id=f.id) AS reaction_count  from feeds f 
    LEFT JOIN users u ON f.user_id = u.id 
    LEFT JOIN community c ON f.community_id = c.id WHERE (LOWER(f.content) LIKE LOWER($1) 
    OR LOWER(u.pseudo_name) LIKE LOWER($1) OR LOWER(u.first_name) LIKE LOWER($1) 
    OR LOWER(u.last_name) LIKE LOWER($1)) AND feed_status=true AND f.approve_status=true ORDER BY f.created_date DESC LIMIT 5`,
    //add_testimonial:'INSERT INTO testimonials(author_id, author_name,created_on,publish_status,description,media,thumbnail,media_type,status)VALUES ($1,$2,$3,$4,$5,$6,$7,$8,$9) RETURNING author_id, author_name,created_on,publish_status,description,media,thumbnail,media_type',
    //update_testimonial:'UPDATE testimonials SET description = $1,media = $2,thumbnail = $3,media_type = $4,created_on = $5 WHERE author_id=$6 RETURNING author_id, author_name,created_on,publish_status,description,media,thumbnail,media_type',
    //delete_testimonial:'UPDATE testimonials SET status = $2 WHERE author_id=$1 RETURNING author_id',
    //search_testimonial:'SELECT * FROM testimonials WHERE LOWER(author_name) LIKE LOWER($1) OR LOWER(description) LIKE LOWER($2)',
    //publish_testimonial:'UPDATE testimonials SET publish_status = 1 WHERE author_id = $1 RETURNING author_id, author_name,created_on,publish_status,description,media,thumbnail,media_type',
    condition_delete_by_userid: `DELETE FROM conditions WHERE user_id=$1`,
    get_admin_users_list: `SELECT id,email,phone,pseudo_name,gender,created_date,status FROM users WHERE user_from=$1`,
    get_conditions: `SELECT condition,is_primary,treatment,user_id FROM conditions`,
    get_user_list: `SELECT id,email,phone,pseudo_name,gender,created_date,postal_code,dob,count(*) OVER() AS totalCount,status FROM users WHERE (user_from IS NULL or user_from != 'admin')`,
    get_helingmate_user_list: `SELECT id,email,phone,pseudo_name,gender,created_date,postal_code,dob,count(*) OVER() AS totalCount,status FROM users WHERE user_type=$1`,
    block_user: `UPDATE users SET status = $1 WHERE id=$2;`,
    delete_user: `UPDATE users SET status = $1 WHERE id=$2;`,
    //roles
    create_role: `INSERT INTO roles(role_name,role_desc,created_date,updated_date)VALUES ($1,$2,$3,$3) RETURNING id`,
    create_permissions: `INSERT INTO permission(role_id,module_id,p_create,p_update,p_delete,p_view,publish,created_date,updated_date)VALUES ($1,$2,$3,$4,$5,$6,$7,$8,$8)`,
    edit_role: `UPDATE roles SET role_name = $1,role_desc = $2, updated_date = $4 WHERE id = $3`,
    edit_permissions: `UPDATE permission SET p_create = $1,p_update = $2 ,p_delete=$3,p_view=$4,publish=$5,updated_date=$6 WHERE role_id = $7 AND module_id=$8`,
    delete_role: `UPDATE roles SET  status = false,updated_date=$2 WHERE id = $1`,
    delete_permissions: `UPDATE permission SET status = false,updated_date=$2 WHERE role_id = $1`,
    get_role: `SELECT role_desc as "description",(select count(id) from roles where status = true) as totalCount,r.id, r.role_name as "name",count(u.id) FROM roles r left join users u on u.role_id = r.id WHERE r.status = true GROUP BY r.id LIMIT $1 OFFSET $2;`,
    get_role_search: `SELECT role_desc as "description",(select count(id) from roles where status = true AND ((LOWER(role_name) LIKE LOWER($3) OR LOWER(role_desc) LIKE LOWER($3))) GROUP BY r.id ) as totalCount ,r.id, r.role_name as "name",count(u.id) FROM roles r left join users u on u.role_id = r.id where r.status = true AND (LOWER(role_name) LIKE LOWER($3) OR LOWER(role_desc) LIKE LOWER($3)) GROUP BY r.id LIMIT $1 OFFSET $2;`,
    get_role_detail: `SELECT r.id, role_name as "name", role_desc as "description",m.id as module_id,m.module_name,p_create,p_update,p_view,p_delete,publish FROM roles r left join permission p on p.role_id = r.id left join modules m on m.id = p.module_id where r.id = $1;`,
    get_module: `SELECT id, module_name FROM modules WHERE status = true;`,
    //Admin user
    create_admin_user: `INSERT INTO users(first_name, last_name, email,created_date, updated_date, token, role_id, user_from, status,pseudo_name) VALUES ($1,$2,$3,$4,$4,$5,$6,'admin', 1,'admin');`,
    edit_admin_user: `UPDATE users SET first_name = $1,last_name = $2,email = $3,role_id = $4,updated_date = $5 WHERE id = $6 and status::integer= 1`,
    delete_admin_user: `UPDATE users SET status = 0,updated_date = $1 WHERE id = $2`,
    get_admin_user_list: `SELECT (SELECT count(id) from users where status ::int = 1 AND user_from = 'admin') as totalCount ,u.id,u.first_name,u.last_name,u.email,u.updated_date,u.role_id,r.role_name FROM users u left join roles r on r.id = u.role_id WHERE u.status ::int = 1 and u.user_from = 'admin' limit $1 offset $2`,
    get_admin_user_list_search: `SELECT u.id,(SELECT count(id) from users where status ::int = 1 AND user_from = 'admin'  AND (LOWER(first_name) LIKE LOWER($3) OR LOWER(last_name) LIKE LOWER($3))) as totalCount ,u.first_name,u.last_name,u.email,u.updated_date,u.role_id,r.role_name FROM users u left join roles r on r.id = u.role_id WHERE u.status ::int = 1 and u.user_from = 'admin' AND (LOWER(first_name) LIKE LOWER($3) OR LOWER(last_name) LIKE LOWER($3)) limit $1 offset $2`,
    //manage posts
    change_post_status: `UPDATE feeds set approve_status=$1, unapproval_comments=$3 WHERE id=$2`,
    report_post: `UPDATE feeds set reported=$2, report_type=$3, report_text=$4, report_date=$5, reported_by=$6 WHERE id=$1`,
    reply_post: `INSERT INTO comments(parent_id,type,user_id,comment,status,publish_status,created_date)VALUES ($1,'feeds',$2,$3,$4,$5,$6) RETURNING id`,
    get_user_profile: `SELECT profile_image FROM users WHERE id=$1`,
    //connections
    connect_members: `INSERT INTO connections(user_id1,user_id2,status,created_date)VALUES ($1,$2,$3,$4) RETURNING id`,
    acc_rej_connection: `UPDATE connections SET status =$3, updated_date=$4 WHERE (user_id1=$1 AND user_id2=$2) OR (user_id1=$2 AND user_id2=$1)`,
    chk_connection: `SELECT status FROM connections WHERE (user_id1=$1 AND user_id2=$2) OR (user_id1=$2 AND user_id2=$1)`,
    my_connections: `SELECT c.user_id1, c.user_id2, u.pseudo_name, u.profile_image,u.nationality,u.location FROM connections c
    LEFT JOIN users u ON c.user_id2 = u.id OR (u.id=c.user_id1 AND c.status=1)
    WHERE c.status=1  AND (c.user_id1=$1 OR c.user_id2=$1) AND u.id!=$1 AND u.user_type =$4 ORDER BY u.first_name ASC LIMIT $2 OFFSET $3`,
    condition_members: `SELECT u.id, u.pseudo_name,u.first_name,u.last_name, u.profile_image, u.nationality, u.location, c.condition, c.treatment_id, c.user_id, u.gender, con.user_id1, con.status as connection_status FROM conditions c 
    LEFT JOIN users u ON u.id = c.user_id
    LEFT JOIN connections con ON con.user_id2 = c.user_id 
    WHERE u.id !=$1
    ORDER BY u.first_name ASC`,
    change_admin_password: `UPDATE users SET password = $3, updated_date = $4 WHERE password = $2 AND id = $1 AND status::integer = 1`,
    update_user_token: `UPDATE users SET token = $1, updated_date = $2 WHERE email = $3 AND status::integer = 1`,
    reset_admin_password: `UPDATE users SET password = $2, updated_date = $3 WHERE token = $1 AND status::integer = 1`,
    member_connections:`SELECT c.user_id1, c.user_id2, u.pseudo_name, u2.pseudo_name as u2_pseudo, u.profile_image,u.nationality,u.location FROM connections c
    LEFT JOIN users u ON u.id=c.user_id2
    LEFT JOIN users u2 ON u2.id=c.user_id1
    WHERE c.status=1  AND (c.user_id1=$1 OR c.user_id2=$1) AND u.id!=$4 ORDER BY u.first_name ASC LIMIT $2 OFFSET $3`,
    chk_connected: `SELECT SUM(status) as status from(SELECT status FROM connections WHERE user_id1=$1 AND user_id2=$2 UNION ALL SELECT status FROM connections WHERE user_id1=$2 AND user_id2=$1) x`,
    chk_reaction_comment: `SELECT COUNT(*) FROM reactions WHERE comment_id=$1 AND user_id=$2;`,
    add_reaction_comment: `INSERT INTO reactions(reaction_type, reaction_status, content_id, content_type, feed_id, comment_id, user_id, created_date, updated_date) VALUES ($1,$2,$3,$4,$5,$6,$7,$8,$8) RETURNING id`,
    update_reaction_comment: `UPDATE reactions SET reaction_type=$1,reaction_status=$2,updated_date=$5 WHERE user_id=$3 AND comment_id=$4 RETURNING id`,
    get_user_permission: `SELECT r.id, role_name as "name", role_desc as "description",m.module_name,p_create,p_update,p_view,p_delete,publish FROM users u left join roles r on u.role_id = r.id left join permission p on p.role_id = r.id left join modules m on m.id = p.module_id where u.id = $1 AND u.status::integer = 1;`,
    // Notification setup
    update_user_chatbot_status:'UPDATE user_active_session SET chatbox_active=$2 WHERE user_id=$1 RETURNING chatbox_active,user_id',
    get_user_chatbot_status:'select chatbox_active,user_id  from user_active_session where user_id = $1',
    check_live_user:'SELECT id FROM user_active_session WHERE user_id=$1 AND registration_token_firebase=$2',
    add_live_user:`INSERT INTO user_active_session(user_id,registration_token_firebase,user_type,login_status,login_time ) VALUES ($1,$2,$3,$4,$5) RETURNING id`,
    remove_live_user:'UPDATE user_active_session SET registration_token_firebase=null,login_status=$3,logout_time=$4 WHERE user_id=$1 AND registration_token_firebase=$2 RETURNING id',
    get_live_user_tokens:'SELECT registration_token_firebase FROM user_active_session WHERE user_id=$1 AND login_status=$2',
    get_user_from_postid:'SELECT id,pseudo_name FROM users WHERE id=(SELECT user_id FROM feeds WHERE id=$1)',
    get_user_from_commentid:'SELECT user_id FROM comments WHERE id=$1',
    save_notification:'INSERT INTO notifications(notification,sender_id,receiver_id,sent_on,type,data,status,read_status) VALUES ($1,$2,$3,$4,$5,$6,$7,$8)',
    list_notifications:'SELECT n.id,n.notification,n.type,n.sent_on,n.sender_id,n.data,u.profile_image,n.read_status FROM notifications n LEFT JOIN users u ON n.sender_id = u.id WHERE n.receiver_id = $1 AND n.status::integer = 1 ORDER BY sent_on DESC LIMIT $2 OFFSET $3',
    search_notifications:'SELECT n.id,n.notification,n.type,n.sent_on,n.sender_id,u.profile_image,n.read_status FROM notifications n LEFT JOIN users u ON n.sender_id = u.id WHERE n.receiver_id = $1 AND n.status::integer = 1 AND LOWER(n.notification) LIKE LOWER($4) ORDER BY sent_on DESC LIMIT $2 OFFSET $3',
    get_post_details:'SELECT f.id as feed_id, f.content, f.image,f.created_date, f.type, f.approve_status, u.pseudo_name, u.profile_image FROM feeds f LEFT JOIN users u ON f.user_id = u.id WHERE f.id=$1',
    comment_publish_status_set: 'UPDATE comments SET publish_status = $1,unpublish_reason=$3 WHERE id = $2 RETURNING id,comment',
    remove_notification:'UPDATE notifications SET status = 0 WHERE sender_id = $1 AND receiver_id=$2 AND type=$3 RETURNING id',
    get_live_user_tokens_by_type:'SELECT registration_token_firebase,user_id FROM user_active_session WHERE user_type=$1 AND login_status=$2',   
    get_user_conditions_and_firebase_tokens:`select u.id as user_id , u.pseudo_name, c."condition", c.condition_id,a.registration_token_firebase
    from users u, conditions c,(select uas.user_id,uas.registration_token_firebase,uas.login_time,max(login_time) over (partition by user_id) as last_login
    from user_active_session uas where uas.login_status = 1 order by uas.user_id, uas.login_time) a
    where u.id = c.user_id and c.status::int = 1 and c.is_primary = 1 and a.user_id = u.id and a.last_login = a.login_time order by u.id`,   
    get_live_helingmate_tokens:'SELECT registration_token_firebase,user_id FROM user_active_session WHERE user_id  in (select u.id from users u , connections c where u.id = c.user_id1 and c.user_id2 = (select id from users where id = $1 and status = $3) and u.status = $3 and c.status = $2) AND login_status=$2',   
    read_notification:'UPDATE notifications SET read_status = 1 WHERE id = $1 RETURNING id',
    change_user_status:`UPDATE users SET status=$2 WHERE id=$1`,
    check_existing_pseudoname:'SELECT COUNT(*) FROM users WHERE LOWER(pseudo_name)=LOWER($1) AND status::integer=1',

    // Expert consult
    expert_user_chk_email_or_phone: `SELECT id,email,phone FROM users WHERE (email=$1 OR phone=$2) AND status::integer = 1 AND user_type=$3`,
    expert_user_register: `INSERT INTO users(email,first_name, last_name, gender,dob,phone,user_type,created_date,password,status,pseudo_name, clinic_id, department_id,profile_image) VALUES ($1,$2,$3,$4,$5,$6,$7,$8,$9,$10,$11,$12,$13,$14) RETURNING id`,
    expert_sign_in:'SELECT id,first_name,last_name,email,phone,profile_image,user_type,password,clinic_id,login_count FROM users WHERE email=$1 AND user_type=$2 AND status=$3',
    clinic_add: `INSERT INTO clinic("clinicName", "address", "clinicType", "clinicImages", "clinicLogo", "created_on", "updated_on", "status","description","phone",mhm_tax_percentage,tax_percentage) VALUES ($1,$2,$3,$4,$5,$6,$6,$7,$8,$9,$10) RETURNING "clinic_id"`,
    get_clinic_details:'SELECT c.*,u.first_name,u.last_name FROM clinic c LEFT JOIN users u ON c.clinic_id = u.clinic_id WHERE c.clinic_id=$1 AND c.status=true AND u.id=$2',
    edit_clinic_details:'UPDATE clinic SET "clinicLogo"=$2,"description"=$3,mhm_tax_percentage=$4,tax_percentage=$5 WHERE clinic_id=$1 RETURNING "clinic_id" ',
    department_add: `INSERT INTO department("clinic_id", "departmentName", "departmentDescription", "departmentImages", "departmentIndexId", "departmentLogo", "created_on", "updated_on", "status", "created_by", "updated_by","service_type") VALUES ($1,$2,$3,$4,$5,$6,$7,$7,$8,$9,$9,$10) RETURNING clinic_id,"departmentName","departmentDescription","departmentImages","departmentIndexId", "departmentLogo"`,
    expert_user_check:'SELECT id FROM users WHERE email=$1 AND user_type=$2 AND status=$3',
    expert_change_password:'UPDATE users SET password=$4,updated_date=$5 WHERE email=$1 AND user_type=$2 AND status=$3 RETURNING id',
    expert_change_password_id:'UPDATE users SET password=$3,updated_date=$4 WHERE id=$1 AND status=$2 RETURNING id',
    add_expert_details:'INSERT INTO physician_details(physician_id,registraion_number,registraion_council,registraion_year,speciality,medical_school,experience,qualification,address_line1,address_line2,state_name,pincode,first_visit_pay,follow_up_pay,expert_document,consultation_duration) values ($1,$2,$3,$4,$5,$6,$7,$8,$9,$10,$11,$12,$13,$14,$15,$16)',
    add_expert_services:'INSERT INTO physician_service (service_id,physician_dtl_id,created_by) values ($1,$2,$3)',
    physician_details_by_id:'SELECT u.profile_image,u.first_name,u.last_name,u.dob,u.gender,pd.registraion_number,pd.registraion_council,pd.registraion_year,pd.qualification,pd.medical_school,pd.speciality,u.department_id,pd.experience,u.email,u.phone,pd.address_line1,pd.address_line2,pd.state_name,pd.pincode,pd.first_visit_pay,pd.follow_up_pay,pd.bio,pd.sign,pd.expert_document,pd.consultation_duration,c.tax_percentage,c.mhm_tax_percentage FROM users u LEFT JOIN physician_details pd ON u.id = pd.physician_id LEFT JOIN clinic c ON c.clinic_id = u.clinic_id WHERE u.id=$1',
    list_experts_by_department:'SELECT id as "expertId",profile_image,first_name,last_name,gender,(SELECT "departmentName" as specialisation FROM department WHERE "departmentId"=$1) FROM users WHERE department_id = $1 and status =$2 and user_type=$3 ORDER BY created_date DESC LIMIT $4 OFFSET $5',
    departmentindex_list:'SELECT "departmentIndexId","departmentIndexName" FROM "departmentIndex" WHERE status=$1',
    department_list_by_clinic_id:'SELECT d.clinic_id,d."departmentId",d."departmentName",d."departmentDescription",d."departmentImages",d."departmentIndexId",d."departmentLogo",count(u.id) as physicianCount FROM department d LEFT JOIN users u ON d."departmentId" = u.department_id AND u.status::integer = 1 WHERE d.clinic_id=$1 AND d.status=$2',
    list_experts_by_clinic:'SELECT id as "expertId",profile_image,first_name,last_name,gender,(SELECT "departmentName" as specialisation FROM department WHERE "departmentId"=department_id) FROM users WHERE clinic_id = $1 and status::integer =1 and user_type=$2',
    cr_add: `INSERT INTO "consultationRequest"("physicianID","departmentId","patientID","appointmentTimestamp","physicianTimeManagementId",status,created_on, updated_on, disease,service_type,consent_to_share_information,consultation_type) values ($1,$2,$3,$4,$5,$6,$7,$7,$8,$9,$10,$11) RETURNING "consultationRequestId", created_on`,
    update_appointment_Time: `UPDATE consultationRequest  SET payment_status=$5, status=$4, "appointmentTimestamp"=$2,"physicianTimeManagementId" =$3 WHERE "consultationRequestId" =$1 RETURNING "consultationRequestId",status`,
    expert_bio_sign_add:'UPDATE physician_details SET bio=$2,sign=$3 WHERE physician_id=$1 RETURNING physician_id,bio,sign',
    expert_sign_add:'UPDATE physician_details SET sign=$2 WHERE physician_id=$1 RETURNING physician_id,bio,sign',
    expert_bio_add:'UPDATE physician_details SET bio=$2 WHERE physician_id=$1 RETURNING physician_id,bio,sign',
    expert_address_edit:'UPDATE physician_details SET address_line1=$2,address_line2=$3,state_name=$4,pincode=$5 WHERE physician_id=$1 RETURNING physician_id,address_line1,address_line2,state_name,pincode',
    update_profile_image:'UPDATE users SET profile_image=$2 WHERE id=$1 RETURNING id as physician_id,profile_image',
    expert_user_physician_edit:'UPDATE users SET email=$1,first_name=$2,last_name=$3,gender=$4,dob=$5,phone=$6,updated_date=$7,clinic_id=$8,department_id=$9,profile_image=$10 WHERE id=$11 and status=$12 RETURNING id',
    edit_expert_details:'UPDATE physician_details SET registraion_number=$1,registraion_council=$2,registraion_year=$3,speciality=$4,medical_school=$5,experience=$6,qualification=$7,address_line1=$8,address_line2=$9,state_name=$10,pincode=$11,first_visit_pay=$12,follow_up_pay=$13,expert_document=$14,consultation_duration=$16 WHERE physician_id=$15 RETURNING physician_id',
    expert_user_physician_delete:'UPDATE users SET status = $2 WHERE id=$1 RETURNING id as "expertId"',
    list_patients_by_expert_id:'SELECT DISTINCT u.id,u.profile_image,u.first_name,u.last_name,u.dob,u.gender,u.phone,u.location FROM users u LEFT JOIN "consultationRequest" cr ON u.id = cr."patientID" WHERE cr."physicianID"=$1 AND cr.status=$2',
    physician_professional_details_by_id:'SELECT u.profile_image,u.first_name,u.last_name,u.dob,u.gender,pd.registraion_number,pd.registraion_council,pd.registraion_year,pd.qualification,pd.medical_school,u.department_id,pd.experience,pd.speciality,u.email,u.phone,pd.bio,pd.sign FROM users u LEFT JOIN physician_details pd ON u.id = pd.physician_id WHERE u.id=$1',
    physician_address_details_by_id:'SELECT address_line1,address_line2,state_name,pincode FROM physician_details WHERE physician_id=$1',
    physician_payment_details_by_id:'SELECT pd.first_visit_pay,pd.follow_up_pay,c.mhm_tax_percentage,c.tax_percentage FROM physician_details pd LEFT JOIN users u ON u.id=pd.physician_id LEFT JOIN clinic c ON c.clinic_id=u.clinic_id WHERE pd.physician_id=$1',
    get_department_details_by_id:'SELECT clinic_id,"departmentId","departmentName","departmentDescription","departmentImages","departmentIndexId","departmentLogo",(SELECT COUNT(*) as physicianCount FROM users WHERE user_type=$2 AND department_id=$1 AND status::integer = 1),(SELECT COUNT(DISTINCT "patientID") as patientCount FROM "consultationRequest" WHERE "departmentId"=$1),(SELECT COUNT(*) as consultationCount FROM "consultationRequest" WHERE "departmentId"=$1 AND status=$3) FROM department WHERE "departmentId"=$1',
    edit_department:'UPDATE department SET "departmentName"=$1, "departmentDescription"=$2, "departmentImages"=$3, "departmentIndexId"=$4, "departmentLogo"=$5, "updated_on"=$6,"updated_by"=$7, "service_type"=$9 WHERE "departmentId"=$8 RETURNING "departmentId"',
    delete_department:'UPDATE department SET "updated_on"=$1,"updated_by"=$2,"status"=$3 WHERE "departmentId"=$4 RETURNING "departmentId"',
    expert_user_email_check:'SELECT id FROM users WHERE email=$1 AND status=$2 AND id !=$3 AND user_type=$4 ',
    expert_user_phone_check:'SELECT id FROM users WHERE phone=$1 AND status=$2 AND id !=$3 AND user_type=$4 ',
    list_patients_by_clinic_id:'SELECT DISTINCT u.id,u.profile_image,u.first_name,u.last_name,u.dob,u.gender,u.phone,u.location FROM users u LEFT JOIN "consultationRequest" cr ON u.id = cr."patientID" WHERE cr."departmentId" IN (SELECT "departmentId" FROM department WHERE clinic_id=$1 AND status=$2)',
    list_expert_time_slots:'SELECT "physicianTimeManagementId",duration,"startTimeStamp","endTimeStamp" FROM physiciantimemanagement WHERE "physicianId"=$1 AND "startDay"=$2 AND status=true',
    get_patient_past_appointments:'SELECT c."consultationId",(SELECT first_name as expert_first_name FROM users WHERE id=cr."physicianID"),(SELECT last_name as expert_last_name FROM users WHERE id=cr."physicianID"),(SELECT profile_image as expert_profile_image FROM users WHERE id=cr."physicianID"),(SELECT first_visit_pay FROM physician_details WHERE physician_id=cr."physicianID"),c."consultationStartTimestamp",c."consultationEndTimestamp",c.consultation_type,c.case_history,c.presenting_complaint,c.treatment_advice,cr.medical_records_for_consultation,c.prescription,pc.caregiverfirstname,pc.caregiverlastname,pc.patientfirstname,pc.patientlastname,pc.patientdob,pc.relationship FROM consultation c LEFT JOIN "consultationRequest" cr ON cr."consultationRequestId"=c."appointmentId" LEFT JOIN patient_caregiver_consent pc ON pc.appointmentid=cr."consultationRequestId" WHERE cr."patientID"=$1 AND cr."physicianID"=$2 AND cr.status=$3 ORDER BY c."consultationId" DESC LIMIT $4 OFFSET $5',
    consultation_summary:'SELECT c."consultationId",cr."physicianID",cr."patientID",(SELECT first_name as patient_first_name FROM users WHERE id=cr."patientID"),(SELECT last_name as patient_last_name FROM users WHERE id=cr."patientID"),(SELECT gender FROM users WHERE id=cr."patientID"),(SELECT dob as patient_dob FROM users WHERE id=cr."patientID"),u.first_name as expert_first_name,u.last_name as expert_last_name,pd.qualification,pd.address_line1,pd.address_line2,pd.state_name,pd.registraion_number,pd.sign,cl."clinicName",cl.address as "clinicAddress",cl."clinicLogo",cl.phone as "clinicPhone",c."consultationStartTimestamp",c."consultationEndTimestamp",c.case_history,c.presenting_complaint,c.treatment_advice FROM consultation c LEFT JOIN "consultationRequest" cr ON c."appointmentId"=cr."consultationRequestId" LEFT JOIN physician_details pd ON pd.physician_id=cr."physicianID" LEFT JOIN users u ON u.id=cr."physicianID" LEFT JOIN clinic cl ON cl.clinic_id=u.clinic_id WHERE "consultationId"=$1',
    //get_patient_records_for_consult:'SELECT medical_records_for_consultation from "consultationRequest" WHERE "consultationRequestId"=(SELECT "appointmentId" FROM consultation WHERE "consultationId"=$1)',
    get_patient_records_for_consult:'SELECT medical_records_for_consultation from "consultationRequest" WHERE "consultationRequestId"=$1',
    view_timeslots_by_date_range:'SELECT "physicianTimeManagementId","startDay" as day,"startTimeStamp" as "startTime","endTimeStamp" as "endTime",duration FROM physiciantimemanagement WHERE "physicianId"=$1 AND "startDay" >= $2 AND "startDay" <= $3 AND status=true ORDER BY "startDay" ASC',
    cancel_appointment_by_expert:'UPDATE "consultationRequest" SET status=$1, updated_on=$2,"requestRejectReason"=$3 WHERE "consultationRequestId"=$4 RETURNING "consultationRequestId","patientID","requestRejectReason"',
    invite_patient:'INSERT INTO "patientInvite"(name,phone,"emailId",description,created_on,updated_on,invited_by) VALUES ($1,$2,$3,$4,$5,$6,$7)',
    add_complaint:'INSERT INTO "complaints_reported"(patient_id,"consultationRequestId",reason,reported_on,complaint_type,payment_id,refund_status) VALUES ($1,$2,$3,$4,$5,$6,$7) RETURNING complaint_id',
    issue_reply:'UPDATE "complaints_reported" SET reply_to_issue=$1 WHERE complaint_id=$2 RETURNING "consultationRequestId",patient_id,reason',
} 


