import * as express from 'express';
var app = express();

import * as router from './api/index'
import * as bodyParser from 'body-parser';
import configurePassport from './api/config/passport-jwt-config';
import * as cors from 'cors';
import * as fileUpload from 'express-fileupload';
import * as swaggerUi from 'swagger-ui-express'
import swaggerDocument from './api/config/swagger';

app.use(fileUpload());
app.use(cors());

app.use('/api-docs', swaggerUi.serve, swaggerUi.setup(swaggerDocument));

app.set('port', (process.env.APP_PORT));
app.use(bodyParser.json({ limit: "50mb" }));
app.use(bodyParser.urlencoded({limit: '50mb', extended: true, parameterLimit: 1000000}));
configurePassport();

app.use('/', router);
app.listen(app.get('port'), () => {
    console.log('Listening on port ' + app.get('port'));
});



